% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_map.R
\name{plot_schema}
\alias{plot_schema}
\title{Schema of the clusters}
\usage{
plot_schema(
  output_clusters,
  sites_coord,
  system,
  system_conv = NULL,
  colors = "red"
)
}
\arguments{
\item{output_clusters}{list. List of the sites in the clusters: it is the sites_clusters of the output of NPFSS, PFSS, DFFSS, URBFSS, MDFFSS, MRBFSS, MG, MNP, UG or UNP, or the sites_clusters_LH/sites_clusters_W/sites_clusters_P/sites_clusters_R of the MPFSS.}

\item{sites_coord}{numeric matrix. Coordinates of the sites, in the same order that the data for the cluster detection.}

\item{system}{character. System in which the coordinates are expressed: "Euclidean" or "WGS84".}

\item{system_conv}{character. System to convert the coordinates for the plot. Only considered if system is "WGS84". Must be entered as in the PROJ.4 documentation}

\item{colors}{character. Colors of the clusters. If length(colors)=1 all the clusters will be in this color. Else it should be a vector of length the number of clusters to plot.}
}
\value{
No value returned, plots a schema of the sites and the clusters.
}
\description{
This function plots a schema of the sites and the clusters
}
