% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{QWIdata}
\alias{QWIdata}
\title{The national QWI hires data}
\format{
A list with 51 elements. Every element contains a multivariate time series.
}
\source{
\url{https://qwiexplorer.ces.census.gov/}

\url{https://ledextract.ces.census.gov/qwi/all}
}
\usage{
data(QWIdata)
}
\description{
The data on new hires at a national level are obtained from the
Quarterly Workforce Indicators (QWI) of the Longitudinal Employer-Household
Dynamics program at the U.S. Census Bureau (Abowd et al., 2009). The national
QWI hires data covers a variable number of years, with some states providing
time series going back to 1990 (e.g., Washington), and others
(e.g., Massachusetts) only commencing at 2010. For each of 51 states
(excluding D.C. but including Puerto Rico) there is a new hires time series
for each county. Additional description of the data, along with its relevancy
to labor economics, can be found in Hyatt and McElroy (2019).
}
\references{
Abowd, J. M., Stephens, B. E., Vilhuber, L., Andersson, F., McKinney, K. L., Roemer,
M., and Woodcock, S. (2009). The LEHD infrastructure files and the creation of the
quarterly workforce indicators. In \emph{Producer dynamics: New evidence from micro data},
pages 149--230. University of Chicago Press. \doi{10.7208/chicago/9780226172576.003.0006}.

Hyatt, H. R. and McElroy, T. S. (2019). Labor reallocation, employment,
 and earnings: Vector autoregression evidence. \emph{Labour}, \strong{33}, 463--487.
 \doi{doi:10.1111/labr.12153}
}
\keyword{data}
