% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heat_map_tc.R
\name{plot_heat_map_tc}
\alias{plot_heat_map_tc}
\title{Plots heat maps for time courses.}
\usage{
plot_heat_map_tc(
  df,
  replicates = 3,
  mar_x = 3.5,
  ranges = c(-Inf, seq(0, 100, by = 10), Inf)
)
}
\arguments{
\item{df}{output from function output_tcourse}

\item{replicates}{number of replicates in sample. Default set to 3.}

\item{mar_x}{margin x width. Default=3.5}

\item{ranges}{ranges for coloring scheme. Default set to c(seq(0, 100, by=10), Inf)}
}
\value{
heat map for time courses
}
\description{
Returns heat map on timecourses with raw data.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tc(file_nm)
plot_heat_map_tc(df=a, replicates=3, ranges=c(seq(0, 100, by=5), Inf))
plot_heat_map_tc(df=a)
}
