% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpdateAll.R
\name{updateAll}
\alias{updateAll}
\title{Update All Package Data Objects Derived from IPD-IMGT/HLA Database Resources}
\usage{
updateAll(updateType = "all", version = getLatestVersion())
}
\arguments{
\item{updateType}{A character vector of the names of data objects to be updated. By default, updateAll() builds all five data objects (updateType="all"). Alternatively specific data objects can be updated; e.g., updateType="alleleListHistory" or updateType=c("alleleListHistory","fragmentFeatureNames").}

\item{version}{A numeric value or character string identifying the version of the ANHIG/IMGTHLA Github repository to build these objects from. By default, updateAll() calls the getLatestVersion() function to identify the most recent IPD-IMGT/HLA Database release.}
}
\value{
No value is returned. The desired versions of the specified data objects are built into the environment that called updateAll().
}
\description{
Applies updateAlleleListHistory(), atlasFull(), buildGazetteer(), extractGeneTypes(), and ffN() to update the alleleListHistory, HLAatlas, HLAgazetteer, IMGTHLAGeneTypes and fragmentFeatureNames data objects.

A new alleleListHistory data object should be generated with each IPD-IMGT/HLA Database release. The other data objects will likely only change when new genes are added to the IPD-IMGT/HLA Database.
}
\note{
Generating a new HLAatlas can take 5 minutes or more to complete.
}
