% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/41_refined_anchored_lasso.R
\name{collect_active_features_proj}
\alias{collect_active_features_proj}
\title{Collect active features and groups based on projection directions}
\usage{
collect_active_features_proj(
  test_result,
  voting_method = c("majority_voting"),
  group = NULL,
  group_threshold = 1
)
}
\arguments{
\item{test_result}{A result object from \code{mean_comparison_anchor()} containing \code{fold_data}.}

\item{voting_method}{Character. Method to determine active features. Only \code{"majority_voting"} is currently supported.}

\item{group}{Optional grouping vector with feature names. Must match the feature dimension of \code{classifier_coef}.}

\item{group_threshold}{Integer. Minimum number of active features required to declare a group active. Default is 1.}
}
\value{
If \code{group} is provided, returns a list with:
\describe{
\item{active_features}{Character vector of consistently non-zero features.}
\item{active_groups}{Character vector of active groups.}
}
If \code{group} is NULL, returns a character vector of active features only.
}
\description{
Identifies consistently non-zero features across cross-validation folds using a voting scheme and returns active groups if a grouping vector is provided.
}
