% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HTGM3D.R
\name{HTGM3D}
\alias{HTGM3D}
\title{HTGM3D}
\usage{
HTGM3D(dir, geneList, GOGOA3, thresh1, thresh3, mn, mx, pcgMN, pcgMX, verbose)
}
\arguments{
\item{dir}{character string full path name to the directory acting as result repository}

\item{geneList}{character vector of user-supplied genes of interest}

\item{GOGOA3}{return value of subsetGOGOA()}

\item{thresh1}{numerical acceptance threshold for individual ontologies}

\item{thresh3}{numerical acceptance threshold for joint ontology}

\item{mn}{integer min category size threshold passed to trimGOGOA3()}

\item{mx}{integer max category size threshold passed to trimGOGOA3()}

\item{pcgMN}{integer param passed to pruneCatGenes}

\item{pcgMX}{integer param passed to pruneCatGenes}

\item{verbose}{integer vector representing vprint classes}
}
\value{
returns matrix containing information that provides the input needed for running plot3d()
}
\description{
compute matrix to use as input to plot3d()
}
\examples{
\dontrun{
# GOGOA3.RData is too large to include in the R package
# so I need to load it from a file that is not in the package.
# Since this is in a file in my own file system, I could not
# include this as a regular example in the package.
# you can generate it using the package 'minimalistGODB'
# or you can retrieve it from https://github.com/barryzee/GO/tree/main/databases
load("/Users/barryzeeberg/personal/GODB_RDATA/goa_human/GOGOA3_goa_human.RData")

geneList<-cluster52
dir<-tempdir()
mat3d<-HTGM3D(dir,geneList,GOGOA3,thresh1=3,thresh3=3,mn=2,
 mx=10000,pcgMN=2,pcgMX=200,verbose=1:5)
}

}
