% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HTSeedGLM.R
\name{BaseWPDist}
\alias{BaseWPDist}
\title{Distribution of base seed water potential}
\usage{
BaseWPDist(model)
}
\arguments{
\item{model}{Fitted model}
}
\value{
\itemize{
  \item Degrees of freedom
  \item p_value: For testing significance of water potential
  \item stress: Location parameter of the base seed water potential
  \item uniformity: Scale parameter of the base seed water potential
  \item var_stress: Variance of estimator of the location parameter
  \item var_uniformity: Variance of estimator of the scale parameter
}
}
\description{
This function provides the estimates of stress and uniformity parameters along with respective variances using generalised linear model fitted to observed germination percentage of seed. The model can be fitted under logit, probit and cloglog transformations.
}
\examples{
X <- c(0,-0.3,-0.6,-0.9) # Various water potentials
y <- c(44,10,10,4) # Number of germinated seeds
n <- c(100,100,100,100) # Total number of viable seeds
n_y <- n-y
sg.mat <- cbind(y,n_y)
res.glm1 <- glm(sg.mat~ X,family=binomial(link=logit)) # Using logit transformation
my.bdl<- BaseWPDist(res.glm1)
res.glm2 <- glm(sg.mat~ X,family=binomial(link=probit)) # Using probit transformation
my.bdp<- BaseWPDist(res.glm2)
res.glm3 <- glm(sg.mat~ X,family=binomial(link=cloglog))# Using cloglog transformation
my.bdcl<- BaseWPDist(res.glm3)
}
\references{
\itemize{
\item Bradford, K. J. (2002). Applications of Hydrothermal Time to Quantifying and Modeling Seed Germination and Dormancy. Weed Science, 50(2), 248–260. http://www.jstor.org/stable/4046371
\item Kebreab, E., & Murdoch, A. J. (1999). Modelling the effects of water stress and temperature on germination rate of Orobanche aegyptiaca seeds. Journal of Experimental Botany, 50(334), 655-664. doi:10.1093/jxb/50.334.655
\item Dobson, A. J., & Barnett, A. G. (2018). An introduction to generalized linear models. Chapman and Hall/CRC.
}
}
