% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_jarrett1984.R
\name{n_jarrett1984}
\alias{n_jarrett1984}
\title{Compute grain roughness via Jarrett (1984)}
\usage{
n_jarrett1984(radius, slope, restrict = TRUE)
}
\arguments{
\item{radius}{hydraulic radius (R) in meters. The original model was calibrated for
0.15 m < R < 1.68 m}

\item{slope}{channel slope (S) in m/m. The original model was calibrated for
0.002 < S < 0.04.}

\item{restrict}{allows for function parameters to restrict certain values. Type bool. Default TRUE.}
}
\value{
Manning's n
}
\description{
\code{n_jarrett1984} calculate Manning's n using the Jarrett (1984) Method for
estimating grain roughness
}
\examples{
# Result: Manning's n of 0.102
n_jarrett1984(0.3,0.03)

# Result: Manning's n of 0.065
n_jarrett1984(1,0.015)

# Result: Slope must be within 0.002 and 0.04 m.
n_jarrett1984(12,0.05)

}
\references{
Jarrett, R. D. 1984. Hydraulics of High-Gradient Streams. Journal of Hydraulic
Engineering. American Society of Civil Engineers, Vol. 110 (11), pp. 1519-1539.
}
