% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_maynord1991.R
\name{n_maynord1991}
\alias{n_maynord1991}
\title{Compute grain roughness following Maynord (1991)}
\usage{
n_maynord1991(grain, restrict = TRUE)
}
\arguments{
\item{grain}{grain size (d90) in millimeters. The original model was calibrated
for 4.57 mm < d90 < 134 mm.}

\item{restrict}{allows for function parameters to restrict certain values. Type bool. Default TRUE.}
}
\value{
Manning's n
}
\description{
\code{n_maynord1991} calculate Manning's n using the Maynord (1991) method of
estimating grain roughness
}
\examples{
# Result: Manning's n of 0.030
n_maynord1991(100)

# Result: Manning's n of 0.018
n_maynord1991(5)

# Result: Manning's n of 0.027
n_maynord1991(50)

# Result: Manning's n of Grain must be within 4.57 and 134 mm.
n_maynord1991(1)

}
\references{
Maynord, S. T. 1991. Flow Resistance of Riprap. Journal of Hydraulic Engineering.
American Society of Civil Engineers, Vol. 117 (6), pp. 687-696.
}
