% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_hydroGOF.R
\name{GOF}
\alias{GOF}
\alias{gof}
\alias{gof.default}
\alias{valindex}
\alias{valindex.default}
\alias{rPearson}
\alias{rPearson.default}
\alias{sKGE}
\alias{sKGE.default}
\alias{KGE}
\alias{KGE.default}
\alias{NSE}
\alias{NSE.default}
\alias{pbias}
\alias{pbias.default}
\alias{mae}
\alias{mae.default}
\alias{VE}
\alias{VE.default}
\title{Goodness of Fit Functions}
\usage{
gof(sim, obs, ...)

\method{gof}{default}(
  sim,
  obs,
  na.rm = TRUE,
  do.spearman = FALSE,
  s = c(1, 1, 1),
  method = c("2009", "2012"),
  start.month = 1,
  digits = 2,
  fun = NULL,
  ...,
  epsilon.type = c("none", "Pushpalatha2012", "otherFactor", "otherValue"),
  epsilon.value = NA
)

valindex(sim, obs, ...)

\method{valindex}{default}(sim, obs, ...)

rPearson(sim, obs, ...)

\method{rPearson}{default}(
  sim,
  obs,
  fun = NULL,
  ...,
  epsilon.type = c("none", "Pushpalatha2012", "otherFactor", "otherValue"),
  epsilon.value = NA
)

sKGE(sim, obs, ...)

\method{sKGE}{default}(
  sim,
  obs,
  s = c(1, 1, 1),
  na.rm = TRUE,
  method = c("2009", "2012"),
  start.month = 1,
  out.PerYear = FALSE,
  fun = NULL,
  ...,
  epsilon.type = c("none", "Pushpalatha2012", "otherFactor", "otherValue"),
  epsilon.value = NA
)

KGE(sim, obs, ...)

\method{KGE}{default}(
  sim,
  obs,
  s = c(1, 1, 1),
  na.rm = TRUE,
  method = c("2009", "2012", "2021"),
  out.type = c("single", "full"),
  fun = NULL,
  ...,
  epsilon.type = c("none", "Pushpalatha2012", "otherFactor", "otherValue"),
  epsilon.value = NA
)

NSE(sim, obs, ...)

\method{NSE}{default}(
  sim,
  obs,
  na.rm = TRUE,
  fun = NULL,
  ...,
  epsilon.type = c("none", "Pushpalatha2012", "otherFactor", "otherValue"),
  epsilon.value = NA
)

pbias(sim, obs, ...)

\method{pbias}{default}(
  sim,
  obs,
  na.rm = TRUE,
  dec = 1,
  fun = NULL,
  ...,
  epsilon.type = c("none", "Pushpalatha2012", "otherFactor", "otherValue"),
  epsilon.value = NA
)

mae(sim, obs, ...)

\method{mae}{default}(
  sim,
  obs,
  na.rm = TRUE,
  fun = NULL,
  ...,
  epsilon.type = c("none", "Pushpalatha2012", "otherFactor", "otherValue"),
  epsilon.value = NA
)

VE(sim, obs, ...)

\method{VE}{default}(
  sim,
  obs,
  na.rm = TRUE,
  fun = NULL,
  ...,
  epsilon.type = c("none", "Pushpalatha2012", "otherFactor", "otherValue"),
  epsilon.value = NA
)
}
\arguments{
\item{sim}{numeric, vector of simulated values}

\item{obs}{numeric, vector of observed values}

\item{...}{further arguments passed to/from other methods.}

\item{na.rm}{a logical value indicating whether 'NA' should be stripped before the computation proceeds.
When an 'NA' value is found at the i-th position in obs OR sim, the i-th value of obs AND sim are removed before the computation.}

\item{do.spearman}{logical, indicates if the Spearman correlation should be computed. The default is \code{FALSE}.}

\item{s}{argument passed to the \code{\link{KGE}} function.}

\item{method}{argument passed to the \code{\link{KGE}} function.}

\item{start.month}{argument passed to the \code{\link{sKGE}} function.}

\item{digits}{integer, number of decimal places used for rounding the goodness of fit indexes.}

\item{fun}{function to be applied to \code{sim} and \code{obs} in order to obtain transformed values thereof before applying any goodness-of-fit function}

\item{epsilon.type}{argument used to define a numeric value to be added to both \code{sim} and \code{obs} before applying fun. It was designed to allow the use of
logarithm and other similar functions that do not work with zero values. It must be one of the following possible values:
\itemize{
\item{\emph{none}: no value added to \code{sim} or \code{obs}.}
\item{\emph{Pushpalatha2012}: one hundredth of the mean observed values is added to both \code{sim} and \code{obs} as described in Pushpalatha et al., 2012.}
\item{\emph{otherFactor}: the numeric value defined in \code{epsilon.value} is used to multiply the mean observed values instead of the one hundredth (1/100)
described in Pushpalatha et al., (2012). The resulting value is then added to both \code{sim} and \code{obs}.}
\item{\emph{otherValue}: the numeric value defined in \code{epsilon.value} is directly added to both \code{sim} and \code{obs}.}
}}

\item{epsilon.value}{numeric, value to be added to both \code{sim} and \code{obs} when \code{epsilon} = "otherValue".}

\item{out.PerYear}{logical, argument passed to the \code{\link{sKGE}} function.}

\item{out.type}{argument passed to the \code{\link{KGE}} function.}

\item{dec}{argument passed to the \code{\link{pbias}} function.}
}
\value{
\code{gof} Returns a matrix of goodness of fit statistics. \code{mae}, \code{pbias}, \code{NSE}, \code{rPearson}, \code{sKGE}, and \code{KGE} return a numeric of the goodness of fit statistic.
}
\description{
Numerical goodness-of-fit measures between sim and obs, with treatment of missing values.
}
\details{
The \code{gof}, \code{mae}, \code{pbias}, \code{NSE}, \code{rPearson}, \code{sKGE}, and \code{KGE} functions are provided to calculate goodness of fit statistics.
The functions were adapted from the hydroGOF package \url{https://github.com/hzambran/hydroGOF}.
}
\examples{
gof(sim = sample(1:100), obs = sample(1:100))

}
