% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdn_goethals_T.R
\name{cdn_goethals_T}
\alias{cdn_goethals_T}
\title{cdn_goethals_T}
\usage{
cdn_goethals_T(order)
}
\arguments{
\item{order}{integer}
}
\value{
13 or NULL
}
\description{
Checks Hadamard Matrix can be constructed using available T-sequences.
}
\details{
This function checks whether the Hadamard matrix of given order can be constructed using T sequences.
If T sequences of length n,n,n,n are available, Hadamard matrix of order 4n can be constructed.
Returns the value 13, if it is possible otherwise NULL is returned.

T-sequences are available for length of seq(1,73,2) and for 83, 101 and 107 in the internal table.
}
\examples{
cdn_goethals_T(28)
#T-seqeunce of length 7 exists.
#13
cdn_goethals_T(24)
#T-sequence of length 6 does not exist.
#NULL
}
\seealso{
\code{\link{had_goethals_T}} for Goethals-Seidel construction method using T-sequences.
}
