% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/framework.R
\name{hapiFrameSelection}
\alias{hapiFrameSelection}
\title{Selection of hetSNPs to form a framework}
\usage{
hapiFrameSelection(gmt, n = 3)
}
\arguments{
\item{gmt}{a dataframe of genotype data of gamete cells}

\item{n}{a numeric value of the minumum number of gametes with 
observed genotypes at a locus}
}
\value{
a dataframe of genotype data of gamete cells
}
\description{
Selection of hetSNPs to form a framework
}
\examples{
ref <- rep(0,500)
alt <- rep(1,500)

gmt <- data.frame(gmt1=ref, gmt2=alt, gmt3=ref,
gmt4=ref, gmt5=c(alt[1:250], ref[251:500]),
stringsAsFactors = FALSE)

idx <- sort(sample(seq_len(500), 10, replace = FALSE))

gmt[idx,1] <- NA
gmt[idx,2] <- NA
gmt[idx,3] <- NA

gmtFrame <- hapiFrameSelection(gmt = gmt, n = 3)
}
\author{
Ruidong Li
}
