% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetseq.R
\name{HetseqClassify}
\alias{HetseqClassify}
\title{Heterogeneity-seq: Classifying cellular response by gene expression values}
\usage{
HetseqClassify(
  object,
  trajectories,
  score.group = NULL,
  score.name = NULL,
  quantiles = c(0.25, 0.75),
  compareGroups = c("Low", "High"),
  posClass = NULL,
  basefeatures = NULL,
  genes = NULL,
  assay = NULL,
  split = NULL,
  kernel = "radial",
  cross = 10,
  num_cores = 1
)
}
\arguments{
\item{object}{Seurat object}

\item{trajectories}{Matrix of cell-cell trajectories. Columns represent time points, rows represent trajectories of connected cells over time points.}

\item{score.group}{A named vector of response groups. Names represent cells, the values represent the score groups. If no score.group is set, use score.name and quantiles parameters must be set to define score groups.}

\item{score.name}{The name of a numeric Seurat meta data column, which will be used to calculate score groups. Only used if no score.group is given.}

\item{quantiles}{Thresholds of the score.name meta data to define 3 response groups. Low, Middle, High.}

\item{compareGroups}{Which score groups to test. Default: Low vs. High}

\item{posClass}{Define the positive Class for classification.}

\item{basefeatures}{Additional informative features to include in the classification. Must be meta data available in the Seurat object.}

\item{genes}{Vector of genes to test.}

\item{assay}{The name of the Seurat assay to perform Heterogeneity-seq on. If NULL, the default assay will be used.}

\item{split}{Set a training-test data split. Must be in [0,1]}

\item{kernel}{The kernel for the SVM. linear, polynomial, radial or sigmoid. Default: radial.}

\item{cross}{Number of cross-validations.}

\item{num_cores}{The number of cores used in parallel processing.}
}
\value{
Table of log2FC and AUC values for each gene and an additional AUC value for the baseline features.
}
\description{
Classifying the cellular response of control cells using single gene expression (+ informative features) to identify features with the strongest predictive capabilities.
}
\examples{
\donttest{

# Full vignette available on https://grandr.erhard-lab.de/articles/web/hetseq.html

  t <- HetseqClassify(data, trajectories, score.name = "score")
  
  t <- HetseqClassify(data, trajectories, score.group = groups,
          compareGroups = c("Weak", "Strong"))
}
}
