% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogram.R
\name{mean,HistDat-method}
\alias{mean,HistDat-method}
\title{Calculates the mean value of all observations in the histogram dataset}
\usage{
\S4method{mean}{HistDat}(x, ...)
}
\arguments{
\item{x}{An instance of the class HistDat}

\item{...}{Additional arguments that will be ignored}
}
\value{
A numeric of length 1, holding the mean of the observations in the
dataset
}
\description{
Calculates the mean value of all observations in the histogram dataset
}
\details{
An S3 and and S4 generic is defined for this method, allowing
compatibility with existing code that calls \code{\link[base:mean]{base::mean()}} instead of
\verb{[mean()]}, which is defined as an S4 generic in this package
}
\examples{
hd <- HistDat(vals = 1:3, counts = c(1, 2, 1))
mean(hd) # returns 2
}
