% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createManhattandQQ.R
\name{createManhattandQQ}
\alias{createManhattandQQ}
\title{Creating a Manhattan Plot and QQ plot}
\usage{
createManhattandQQ(
  gwas_results,
  highlights_file = NULL,
  suggestive_line = -log10(0.05),
  set_color_vector = c("gray10", "gray60"),
  genomewide_line = -log10(5e-08),
  annotate_Pval = 0.05,
  y_lim = c(0, 8)
)
}
\arguments{
\item{gwas_results}{output file listing SNP-trait association values for GWAS run using PLINK}

\item{highlights_file}{a text file with a 'snp' column listing the SNPs to annotate/color on the Manhattan plot}

\item{suggestive_line}{where to draw a "suggestive" line; default -log10(1e-5).}

\item{set_color_vector}{a character vector listing colors in palette of interest (you must create this chr object before calling the createManhattanandQQ function and assign it to set_color_vector)}

\item{genomewide_line}{where to draw a "genome-wide significant" line; default -log10(5e-8)}

\item{annotate_Pval}{if set, SNPs below this p-value will be annotated on the plot; default is 0.05}

\item{y_lim}{set the y-axis limits; default is c(0,8)}
}
\value{
a Manhattan plot of SNP-trait associations and QQ plot
}
\description{
Creates a Manhattan plot and QQ plot using GWAS results output from PLINK
}
\details{
This function reads in a GWAS result file output from plink2 listing the coordinates, ids, and associated p-values for SNPs under study
This function also has the option of reading in a "highlights" file listing the IDs of SNPs to annotate/color on the Manhattan plot
}
\examples{
#' #load external data.
gwas_results <- system.file(package = "HodgesTools", "extdata",
"createManhattandQQ_example_sum_stats.txt")
snps_to_annotate <- system.file(package = "HodgesTools", "extdata",
"createManhattandQQ_example_highlights_file.txt")

#Make a Manhattan plot that highlights a select list of SNPs subset from GWAS results
createManhattandQQ(gwas_results, highlights_file=snps_to_annotate,
suggestive_line = -log10(0.001), set_color_vector = c("gray10", "gray60"),
genomewide_line = -log10(5e-8), annotate_Pval = 0.001, y_lim =c(0,8))

#Make a Manhattan plot that doesn't highlight a select list of SNPs subset from GWAS results
createManhattandQQ(gwas_results, suggestive_line = -log10(0.001),
set_color_vector = c("gray10", "gray60"), genomewide_line = -log10(5e-8),
annotate_Pval = 0.001, y_lim =c(0,8))
}
\author{
Verda Agan
}
