% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid.R
\name{hybrid}
\alias{hybrid}
\title{Implement Hybrid design with real data}
\usage{
hybrid(dose, nDLT, npts, currdose, nextdose=0, target, ncohort, cohortsize,
              eps1=0.05, eps2=0.05, a=1, b=1, cutoff.eli=0.95, tox.control=TRUE,
              cut.tox=0.8, esc.control=FALSE, cut.esc=0.5, regrule)
}
\arguments{
\item{dose}{a vector containing the numerical dosage of each dose level}

\item{nDLT}{a vector containing the number of patients who experienced dose-limiting
toxicity at each dose level}

\item{npts}{a vector containing the number of patients at each dose level}

\item{currdose}{the dosage at the current dose level}

\item{nextdose}{the dosage of next higher dose level; could be an intermediate dose}

\item{target}{the target toxicity rate}

\item{ncohort}{the total number of cohorts}

\item{cohortsize}{the cohort size}

\item{eps1}{modified Toxicity Probability Interval (mTPI) design parameter epsilon1. Default: 0.05}

\item{eps2}{modified Toxicity Probability Interval (mTPI) design parameter epsilon2. Default: 0.05}

\item{a}{Beta prior shape parameter 1. Default: 1}

\item{b}{Beta prior shape parameter 2. Default: 1}

\item{cutoff.eli}{Posterior probability cutoff of eliminating dose due to unacceptable toxicity. Default: 0.95}

\item{tox.control}{indicator of whether to perform toxicity control. If \code{TRUE}, change "stay"
to "deescalation" if the posterior probability of DLT rate greater than
\code{target+eps2} is greater than the toxicity control cutoff \code{cut.tox}}

\item{cut.tox}{toxicity control cutoff. Default: 0.8}

\item{esc.control}{indicator of whether to perform escalation control. If \code{TRUE}, change decision
of "escalation" to "stay" if the posterior probability of DLT rate less than
\code{target-eps1} is greater than the escalation control cutoff \code{cut.esc}}

\item{cut.esc}{escalation control cutoff. Default: 0.5}

\item{regrule}{indicator of whether to apply additional overdose control rule}
}
\value{
This function returns the decision of implementing the Hybrid design with real trial data
        as a list, including:
        (1) dose transition boundaries of modified mTPI design,
        (2) decision table of modified mTPI design,
        (3) the decision given current data,
        (4) the summary table of tested dose levels
}
\description{
Obtain decision for the next dose level to be tested given current trial data.
}
\examples{
hybrid(dose=c(2,4,8,16,22,28,40), nDLT=c(0,0,0,0,1,0,2), npts=c(3,3,4,6,9,5,16), currdose=40,
       nextdose=54, target=0.3, ncohort=10, cohortsize=3, eps1=0.05, eps2=0.05, a=1, b=1,
       cutoff.eli=0.95, tox.control=TRUE, cut.tox=0.8, regrule=TRUE)

}
