% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation_HBay.R
\name{Import_HBayConfig}
\alias{Import_HBayConfig}
\title{Import HBay Configuration folder}
\usage{
Import_HBayConfig(path)
}
\arguments{
\item{path}{character, path to configuration folder.}
}
\value{
A list with the following components (see ?Hydro3_HBay for details):
    \item{y}{numeric matrix, data.}
    \item{dist}{character, distribution name.}
    \item{prior}{list of lists, prior distributions.}
    \item{SystErrorIndex}{integer vector, index of systematic errors.}
    \item{SystErrorPrior}{list of lists, prior distribution for each systematic error.}
    \item{options}{list, inference options.}
    \item{mcmcoptions}{list, MCMC options.}
    \item{year}{numeric vector, years.}
}
\description{
Imports configuration data as specified with HBay executable.
Returns NULL if configuration folder is not found
}
\examples{
config=Import_HBayConfig('path/to/config')
if(!is.null(config)){
  H3=Hydro3_HBay(y=config$y,dist=config$dist,prior=config$prior,
               SystErrorIndex=config$SystErrorIndex,
               SystErrorPrior=config$SystErrorPrior,
               options=config$options,
               mcmcoptions=config$mcmcoptions)
  Hydro3_Plot(H3)
}
}
