% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC.R
\name{Metropolis_OAAT}
\alias{Metropolis_OAAT}
\title{One-At-A-Time Metropolis sampler}
\usage{
Metropolis_OAAT(f, x0, nsim, sdjump, ...)
}
\arguments{
\item{f}{function, log-pdf of the target distribution}

\item{x0}{numeric vector, starting point}

\item{nsim}{integer, number of simulations}

\item{sdjump}{numeric vector, standard deviation of the Gaussian jump for each component}

\item{...}{other arguments passed to f}
}
\value{
A list with the following components:
    \item{x}{numeric matrix nsim*length(x0), MCMC simulations}
    \item{fx}{numeric vector, corresponding values f(x)}
    \item{moverate}{numeric vector, move rate associated with each component}
}
\description{
Performs nsim iterations of the OAAT Metropolis sampler
(simulated vector is updated one component at a time).
 a.k.a block Metropolis sampler with blocks of length one.
 Sometimes also called 'Metropolis-within-Gibbs'.
}
\examples{
# Bivariate target distribution: beta(0.8,0.4) X exp(1)
f=function(x){stats::dbeta(x[1],0.8,0.4,log=TRUE)+stats::dexp(x[2],log=TRUE)}
x0=c(0.5,2)
sdjump=c(0.5,1)
mcmc=Metropolis_OAAT(f,x0,1000,sdjump)
graphicalpar=par(mfrow=c(1,3))
plot(mcmc$x);hist(mcmc$x[,1]); hist(mcmc$x[,2])
par(graphicalpar)
}
