% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooSatTable.R
\name{satTabp}
\alias{satTabp}
\title{Table of Saturation Densities, Enthalpies and Entropies, Function of Pressure}
\usage{
satTabp(p1, p2, dp)
}
\arguments{
\item{p1}{First Pressure value [MPa]}

\item{p2}{Final Pressure [MPa]}

\item{dp}{Pressure increment [MPa]}
}
\value{
A table of saturation D, h and s, function of p
}
\description{
The function \code{satTabp(p1, p2, dp)} returns a table of 
    threee saturation properties for two phases: Density [kg/m3], 
    Enthalpy [kJ kg-1] and Entropy [kJ kg K-1] for a Pressure interval, p1:p2 [MPa].
}
\details{
This function calls a Fortran DLL that solves the Helmholtz Energy Equation. 
    in accordance with the Revised Release on the IAPWS Formulation 1995 for the 
    Thermodynamic Properties of Ordinary Water Substance for General and Scientific
    Use (June 2014) developed by the International Association for the Properties of
    Water and Steam,  \url{https://iapws.org/relguide/IAPWS-95.html}. It is valid  
    from the triple point to the pressure of 1000 MPa and temperature of 1273.
}
\examples{
p1 <- 1.0
p2 <- 10.
dp <- 0.5
Tabp <- satTabp(p1, p2, dp)
Tabp

p1 <- 0.1
p2 <- 10.
dp <- 0.5
Tabp <- satTabp(p1, p2, dp)
Tabp

}
