% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beta_correction_plot_functions.R
\name{bias_density}
\alias{bias_density}
\title{Density Plot of Bias Corrections from SHAP values}
\usage{
bias_density(q = 0, type = "hist")
}
\arguments{
\item{q}{Numeric value between 0 and 0.5 for quantile bounds. A higher number will trim more from the edges
(useful if outliers are distorting your plot window) Default is 0 (i.e. no trimming)}

\item{type}{Character string specifying plot type: "kde" for kernel density or "hist" for histogram. Default is "hist".}
}
\value{
A list with two ggplot objects:
\itemize{
  \item \code{bias_correction_var}: Faceted plot showing bias correction density from each variable.
    Note that variables with no records contributing to bias correction are dropped from the plot.
  \item \code{bias_correction_total}: Plot showing total corrected bias density.
}
}
\description{
Visualizes the distribution of SHAP corrections that are migrated to bias terms,
showing both per-variable and total bias corrections.

\strong{NOTE} This function signature documents the interface of functions created by \code{\link{create_bias_density}}.
}
\examples{
# This function is created inside explain_iblm() and is output as an item

df_list <- freMTPLmini |> split_into_train_validate_test(seed = 9000)

iblm_model <- train_iblm_xgb(
  df_list,
  response_var = "ClaimRate",
  family = "poisson"
)

explain_objects <- explain_iblm(iblm_model, df_list$test)

explain_objects$bias_density()


# This function must be created, and cannot be called directly from the package
try(
bias_density()
)
}
\seealso{
\code{\link{create_bias_density}}, \code{\link{explain_iblm}}
}
