% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibr_std.R
\name{ibr_std}
\alias{ibr_std}
\title{Standardized values for IBR (Integrated Biomarker Response) index}
\usage{
ibr_std(df, z)
}
\arguments{
\item{df}{A data frame containing values the enzymes activities with at least two levels of one independent variable.}

\item{z}{A data frame with the Z coefficient for each enzyme at each level. If not provided, all z values will be 1.}
}
\value{
Returns a data frame with standardized values for each biomarker per treatment
}
\description{
Returns a data frame with standardized values of IBR useful to do a radar chart. This data is fit for our function ibr_chart() from this package that creates this type of plot.
}
\section{Warnings}{


You must have at least 3 biomarkers and a maximum of 9 biomarkers to perform this index correctly.
}

\section{References}{


Beliaeff, B., & Burgeot, T. (2002). Integrated biomarker response: A useful tool for ecological risk assessment. Environmental Toxicology and Chemistry, 21(6), 1316–1322.

Devin, S., Burgeot, T., Giambérini, L., Minguez, L., & Pain-Devin, S. (2014). The integrated biomarker response revisited: Optimization to avoid misuse. Environmental Science and Pollution Research, 21(4), 2448–2454. https://doi.org/10.1007/s11356-013-2169-9
}

\examples{
data(enzact)
ibr_std(enzact, enzact_coef)

}
