% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatters.R
\name{ICS_mlc}
\alias{ICS_mlc}
\title{Cauchy location and Scatter Estimates for ICS}
\usage{
ICS_mlc(x, location = FALSE, ...)
}
\arguments{
\item{x}{a numeric matrix or data frame.}

\item{location}{a logical indicating whether to include the M-estimate of
location (defaults to \code{FALSE}).}

\item{...}{potential further arguments passed to \code{\link[ICS:ICS_scatter]{ICS::ICS_tM()}}.}
}
\value{
An object of class \code{"ICS_scatter"} with the following
components:
\item{location}{if requested, a numeric vector giving the location
estimate.}
\item{scatter}{a numeric matrix giving the estimate of the scatter matrix.}
\item{label}{a character string providing a label for the scatter matrix.}
}
\description{
It is a wrapper for the Cauchy estimator of location and scatter
for a multivariate t-distribution, as computed by \code{\link[ICS:tM]{ICS::tM()}}.
}
\seealso{
\code{\link[ICS:tM]{ICS::tM()}}, \code{\link[ICS:ICS_scatter]{ICS::ICS_tM()}}
}
\author{
Andreas Alfons and Aurore Archimbaud
}
