% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICV.R
\name{C_ICV}
\alias{C_ICV}
\title{The ICV rescaling constant.}
\usage{
C_ICV(alpha, sigma)
}
\arguments{
\item{alpha}{first parameter of the selection kernel,}

\item{sigma}{second parameter of the selection kernel.}
}
\value{
The ICV rescaling constant \eqn{C}.
}
\description{
Computing the ICV rescaling constant defined by expression (3) of Savchuk, Hart, and Sheather (2010).
}
\details{
Calculation of the ICV rescaling constant \eqn{C} defined by (3) in Savchuk, Hart, and Sheather (2010). The constant is a function of the parameters \eqn{(\alpha,\sigma)} of the selection kernel \code{\link{L_ICV}} defined by expression (4) in the same article. The Gaussian kernel is to be used for computing the ultimate density estimate.
}
\examples{
# ICV rescaling constant for the selection kernel with (alpha,sigma)=(2.42,5.06).
C_ICV(2.42,5.06)
}
\references{
Savchuk, O.Y., Hart, J.D., Sheather, S.J. (2010). Indirect cross-validation for density estimation. \emph{Journal of the American Statistical Association}, 105(489), 415-423.
}
\seealso{
\code{\link{ICV}}, \code{\link{h_ICV}}, \code{\link{L_ICV}}, \code{\link{MISE_mixnorm}}, \code{\link{KDE_ICV}}, \code{\link{LocICV}}.
}

