% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JIC.R
\name{JIC}
\alias{JIC}
\title{Joint Information Criterion}
\usage{
JIC(model)
}
\arguments{
\item{model}{a "lm" or "glm" object}
}
\value{
JIC measurement of the model
}
\description{
Joint Information Criterion (JIC) for "lm" and "glm" objects.
}
\details{
JIC (Rahman and King, 1999) is calculated as

\deqn{-2LL(theta) + 1/2*(klog(n) - nlog(1-k/n))}
}
\examples{
x1 <- rnorm(100, 3, 2)
x2 <- rnorm(100, 5, 3)
x3 <- rnorm(100, 67, 5)
err <- rnorm(100, 0, 4)

## round so we can use it for Poisson regression
y <- round(3 + 2*x1 - 5*x2 + 8*x3 + err)

m1 <- lm(y~x1 + x2 + x3)
m2 <- glm(y~x1 + x2 + x3, family = "gaussian")
m3 <- glm(y~x1 + x2 + x3, family = "poisson")

JIC(m1)
JIC(m2)
JIC(m3)

}
\references{
Rahman, M. S., & King, M. L. (1999). Improved model selection criterion. Communications in Statistics-Simulation and Computation, 28(1), 51-71.
}
