% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kSearch.R
\name{kSearch}
\alias{kSearch}
\title{Relevant Component Estimation via Iterative Search}
\usage{
kSearch(
  X,
  method,
  search = c("forward", "backward", "binary"),
  alpha = 0.05,
  early_stop = NULL,
  min_dim = NULL,
  max_dim = NULL,
  ...
)
}
\arguments{
\item{X}{A data matrix with \eqn{p>1} columns.}

\item{method}{A function that performs a hypothesis test given \code{X} and dimension \code{k}. 
For more details on supported tests, see the
"Details" section below.}

\item{search}{A character string specifying the search strategy. 
   Options are \code{forward} (default), \code{backward} and \code{binary}. For more details on search techniques, see the
"Details" section below.}

\item{alpha}{A numeric significance level (default = 0.05) used as the threshold for rejecting the null hypothesis.}

\item{early_stop}{Logical or \code{NULL}. Controls whether the search stops early once the null hypothesis is not rejected. 
If \code{NULL} (default), the behavior is determined by the selected search strategy: \code{TRUE} for \code{"forward"} and \code{"backward"}, 
and \code{FALSE} for \code{"binary"}. If explicitly set to \code{TRUE} or \code{FALSE}, this overrides the strategy's default behavior.}

\item{min_dim}{Optional integer to limit the minimum dimension to search. By default, this is set according to the \code{method} being used.}

\item{max_dim}{Optional integer to limit the maximum dimension to search. By default, this is set according to the \code{method} being used.}

\item{...}{Additional arguments passed to the testing function \code{method}.}
}
\value{
An object of class \code{ictest} inheriting from \code{htest}, with additional elements:
\describe{
  \item{\code{tested.ks}}{An integer vector of all tested values of \code{k} during the search.}
  \item{\code{tested.ks.pvals}}{A numeric vector of p-values corresponding to each tested \code{k}.}
}
}
\description{
Performs dimension estimation using various search strategies (forward, backward, binary)
and hypothesis testing methods that evaluate whether the true dimension \eqn{d \leq k}.
The search continues until a p-value exceeds the specified alpha threshold, which indicates
that the null hypothesis is not rejected. The search can optionally continue to test all values, as there may not be a global optimum 
in the tested range.
}
\details{
This function is designed to work with the following tests:
\itemize{
  \item \code{\link[ICtest]{FOBIasymp}}, \code{\link[ICtest]{FOBIboot}}
  \item \code{\link[ICtest]{ICSboot}}
  \item \code{\link[ICtest]{NGPPsim}}
  \item \code{\link[ICtest]{PCAasymp}}, \code{\link[ICtest]{PCAboot}}, \code{\link[ICtest]{PCAschott}}
  \item \code{\link[ICtest]{SIRasymp}}, \code{\link[ICtest]{SIRboot}}
}
These tests evaluate the null hypothesis that the true dimension \eqn{d \leq k}, and return
a p-value indicating whether the null is rejected or not.

The search work as follows:
\itemize{
  \item \code{"forward"} (default) performs a linear search starting from the smallest possible value of \code{k} and incrementing upward. Returns the smallest \code{k} where the null is not rejected.
  \item \code{"backward"} performs a linear search starting from the largest possible value of \code{k} and decrementing downward. Returns \code{k}+1, where \code{k} is the largest dimension where the null is rejected.
  \item \code{"binary"} splits the possible range of \code{k}s in half and performs a binary search. This search may skip testing some possible \code{k} values, but it is typically faster than linear search.
  }
}
\examples{
# Applying forward search with PCAasymp while evaluating 
# all valid values of k (early_stop = FALSE)
n <- 200
S <- cbind(rnorm(n, sd = 2), rnorm(n, sd = 1.5),  
           rnorm(n), rnorm(n), rnorm(n))
A <- rorth(5)
X <- S \%*\% t(A)
result <- kSearch(
  X = X, 
  method = PCAasymp, 
  alpha = 0.05, 
  search = "forward", 
  early_stop = FALSE 
)

result

}
\author{
Katariina Perkonoja
}
