% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SubgridMoransI.R, R/SubgridStats.R
\name{SubgridMoransI}
\alias{SubgridMoransI}
\alias{SubgridStats}
\title{Compute statistics for subgrids}
\usage{
SubgridMoransI(inputrast1, factv1, facth1, rad1 = 1)

SubgridStats(inputrast1, factv1, facth1, statistic = "var")
}
\arguments{
\item{inputrast1}{a raster as produced by terra::rast}

\item{factv1}{an odd integer for the vertical dimension of sub-grids}

\item{facth1}{an odd integer for the horizontal dimension of sub-grids}

\item{rad1}{an integer indicating the neighbourhood radius for Moran's I
statistic calculations in rows/columns. Any cell within a distance of rad1
cells of the focal cell is considered to be in its neighbourhood.}

\item{statistic}{desired output statistic: It should be one of "mean",
"var", or "sum". Default setting is var.}
}
\value{
A data frame is returned with the following column names: rowcent,
colcent, frowmin, frowmax, fcolmin, fcolmax, and a column for the output
statistic.
}
\description{
Functions that facilitate calculation of statistics at the sub-grid level.
These may be useful for drivers  of movement speed or direction if used in
tandem with \code{\link{DispField}}, \code{\link{DispFieldST}}, or
\code{\link{DispFieldSTall}}.
}
\details{
Note that when using radius to define the neighbourhood in Moran's I
calculations, a radius of one corresponds to the rook's neibhourhood. Values
that are NA or Inf are not included in calculations of the Moran's I
statistic nor in any of the other statistics that can be computed.
}
\examples{
(TestMat <- matrix(c(1, 0, 1, 0, 1,
                     0, 1, 0, 1, 0,
                     1, 0, 1, 0, 1,
                     0, 1, 0, 1, 0,
                     1, 0, 1, 0, 1),
                    nrow = 5))

TestRast <- terra::rast(TestMat)
terra::plot(TestRast)

SubgridMoransI(TestRast, factv1 = 5, facth1 = 5, rad1 = 1)
# using rad1 = 1 is equivalent to using the rooks neighbourhood
# and so the output should be -1.

(TestMat <- matrix(c(1, 0, 1, 0, 1,
                    0, 1, 0, 1, 0,
                    1, 0, 1, 0, 1,
                    0, 1, 0, 1, 0,
                    1, 0, 1, 0, 1),
                    nrow = 5))

TestRast <- terra::rast(TestMat)
terra::plot(TestRast)

SubgridStats(TestRast, factv1 = 5, facth1 = 5, statistic = "mean")
SubgridStats(TestRast, factv1 = 5, facth1 = 5, statistic = "var")
SubgridStats(TestRast, factv1 = 5, facth1 = 5, statistic = "sum")

}
\seealso{
\code{\link{DispStats}} and \code{\link{DispMoransI}}for functions
that compute statistics at presumed source or sink locations in each region
of interest.
}
