% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Finalised_coding.R
\name{ID}
\alias{ID}
\title{Multiple change-point detection in piecewise-constant or continuous, piecewise-linear
signals using the Isolate-Detect methodology}
\usage{
ID(xd, th.cons = 1, th.cons_lin = 1.4, th.ic = 0.9, th.ic.lin = 1.25,
  lambda = 3, lambda.ic = 10, contrast = c("mean", "slope"), ht = FALSE,
  scale = 3)
}
\arguments{
\item{xd}{A numeric vector containing the data in which you would like to find
change-points.}

\item{th.cons}{A positive real number with default value equal to 1. It is
used to define the threshold, if the thresholding approach (explained in \code{\link{pcm_th}})
is to be followed to detect the change-points in the scenario of piecewise-constant signals.}

\item{th.cons_lin}{A positive real number with default value equal to 1.4. It is
used to define the threshold, if the thresholding approach (explained in \code{\link{cplm_th}})
is to be followed to detect the change-points in the scenario of continuous, piecewise-linear signals.}

\item{th.ic}{A positive real number with default value equal to 0.9. It is
useful only if the model selection based Isolate-Detect method (described in
\code{\link{pcm_ic}}) is to be followed for the scenario of piecewise-constant signals.
It is used to define the threshold value that will be used at the first step (change-point
overestimation) of the model selection approach.}

\item{th.ic.lin}{A positive real number with default value equal to 1.25. It is
useful only if the model selection based Isolate-Detect method (described in
\code{\link{cplm_ic}}) is to be followed for the scenario of continuous, piecewise-linear signals.
It is used to define the threshold value that will be used at the first step (change-point
overestimation) of the model selection approach.}

\item{lambda}{A positive integer with default value equal to 3. It is used only
when the threshold based approach is to be followed and it defines the distance
between two consecutive end- or start-points of the right- or left-expanding intervals,
respectively.}

\item{lambda.ic}{A positive integer with default value equal to 10. It is used only
when the information criterion based approach is to be followed and it defines
the distance between two consecutive end- or start-points of the right- or
left-expanding intervals, respectively.}

\item{contrast}{A character string, which defines the type of the contrast function to
be used in the Isolate-Detect algorithm. If \code{contrast = ``mean''}, then the algorithm
looks for changes in a piecewise-constant signal. If \code{contrast = ``slope''},
then the algorithm looks for changes in a continuous, piecewise-linear signal.}

\item{ht}{A logical variable with default value equal to \code{FALSE}. If \code{FALSE},
the noise is assumed to follow the Gaussian distribution. If \code{TRUE}, then the
noise is assumed to follow a distribution that has tails heavier than those of the
Gaussian distribution.}

\item{scale}{A positive integer number with default value equal to 3. It is
used to define the way we pre-average the given data sequence only if
\code{ht = TRUE}. See the Details in \code{\link{ht_ID_pcm}} for more information on
how we pre-average.}
}
\value{
A list with the following components:
  \tabular{ll}{
   \cr \code{cpt} \tab A vector with the detected change-points.
   \cr \code{no_cpt} \tab The number of change-points detected.
   \cr \code{fit} \tab A numeric vector with the estimated signal.
   \cr \code{solution_path} \tab A vector containing the solution path.
 }
}
\description{
This is the main, general function of the package. It employs more specialised functions in
order to estimate the number and locations of multiple change-points in the noisy, piecewise-constant
or continuous, piecewise-linear input vector \code{xd}. The noise can either follow the Gaussian
distribution or not. The approach that is followed is a hybrid between the thresholding approach
(explained in \code{\link{pcm_th}} and \code{\link{cplm_th}}) and the information criterion approach
(explained in \code{\link{pcm_ic}} and \code{\link{cplm_ic}}) and estimates the change-points
taking into account both these approaches. Further to the number and the location of the estimated
change-points, \code{\link{ID}}, returns the estimated signal, as well as the solution path.
For more information and the relevant literature reference, see Details.
}
\details{
The data points provided in \code{xd} are assumed to follow \deqn{X_t = f_t + \sigma\epsilon_t; t = 1,2,...,T,}
  where \eqn{T} is the total length of the data sequence, \eqn{X_t} are the observed
  data, \eqn{f_t} is a one-dimensional, deterministic signal with abrupt structural
  changes at certain points, and \eqn{\epsilon_t} are independent and identically
  distributed random variables with mean zero and variance one. In this function,
  the following scenarios for \eqn{f_t} are implemented.
  \itemize{
  \item {Piecewise-constant signal with Gaussian noise.

  Use \code{contrast = ``mean''} and \code{ht = FALSE} here.}

  \item {Piecewise-constant signal with heavy-tailed noise.

  Use \code{contrast = ``mean''} and \code{ht = TRUE} here.}

  \item {Continuous, piecewise-linear signal with Gaussian noise.

  Use \code{contrast = ``slope''} and \code{ht = FALSE} here.}

  \item {Continuous, piecewise-linear signal with heavy-tailed noise.

  Use \code{contrast = ``slope''} and \code{ht = TRUE} here.}
  }
  In the case where \code{ht = FALSE}: the function firstly detects the change-points using
  \code{\link{win_pcm_th}} (for the case of piecewise-constant signal) or \code{\link{win_cplm_th}}
  (for the case of continuous, piecewise-linear signal). If the estimated number of change-points
  is greater than 100, then the result is returned and we stop. Otherwise, \code{\link{ID}} proceeds
  to detect the change-points using \code{\link{pcm_ic}} (for the case of piecewise-constant signal)
  or \code{\link{cplm_ic}} (for the case of continuous, piecewise-linear signal) and this is what is
  returned.\cr
  In the case where \code{ht = TRUE}: First we pre-average the given data sequence using \code{\link{normalise}}
  and then, on the obtained data sequence, we follow exactly the same procedure as the one when \code{ht = FALSE}
  above.\cr
  More details can be found in ``Detecting multiple generalized change-points by isolating single ones'',
  Anastasiou and Fryzlewicz (2018), preprint.
}
\examples{
single.cpt.mean <- c(rep(4,3000),rep(0,3000))
single.cpt.mean.normal <- single.cpt.mean + rnorm(6000)
single.cpt.mean.student <- single.cpt.mean + rt(6000, df = 5)
cpt.single.mean.normal <- ID(single.cpt.mean.normal)
cpt.single.mean.student <- ID(single.cpt.mean.student, ht = TRUE)

single.cpt.slope <- c(seq(0, 1999, 1), seq(1998, -1, -1))
single.cpt.slope.normal <- single.cpt.slope + rnorm(4000)
single.cpt.slope.student <- single.cpt.slope + rt(4000, df = 5)
cpt.single.slope.normal <- ID(single.cpt.slope.normal, contrast = "slope")
cpt.single.slope.student <- ID(single.cpt.slope.student, contrast = "slope", ht = TRUE)
}
\seealso{
\code{\link{ID_pcm}}, \code{\link{ID_cplm}}, \code{\link{ht_ID_pcm}}, and
\code{\link{ht_ID_cplm}}, which are the functions that are employed
in \code{\link{ID}}, depending on which scenario is imposed by the input arguments.
}
\author{
Andreas Anastasiou, \email{a.anastasiou@lse.ac.uk}
}
