% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChisqTest_Distribution.R
\name{ChisqTest_Distribution}
\alias{ChisqTest_Distribution}
\title{Loss and solution sources distribution informations}
\usage{
ChisqTest_Distribution(Data)
}
\arguments{
\item{Data}{It is a data frame object containing data from total number per repetition of loss source and solution source.}
}
\value{
Return distribution of loss and solution sources: aggregate, random, or regular. This information is important to check
whether the problem or solution occurs randomly or not. This has an impact on the decision making associated with increasing
or reducing of the problem.
}
\description{
Indicates the distribution of loss and solution sources: aggregate, random or regular.
}
\examples{
data("DataLossSource")
ChisqTest_Distribution(DataLossSource)

data("DataSolutionSource")
ChisqTest_Distribution(DataSolutionSource)
}
\seealso{
\code{\link{EffectivenessOfSolution}} ,  \code{\link{LossSource}}  ,  \code{\link{ReductionDamage}}
}
\author{
Germano Leao Demolin-Leite (Instituto de Ciencias Agrarias da UFMG) \cr
Alcinei Mistico Azevedo (Instituto de Ciencias Agrarias da UFMG)
}
