% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{computeIMEC}
\alias{computeIMEC}
\title{Computes the Ising model of explanatory coherence.}
\usage{
computeIMEC(
  matrix,
  evidence,
  phenomena,
  theory1,
  theory2 = character(),
  analytic = TRUE,
  analogy = numeric()
)
}
\arguments{
\item{matrix}{matrix of explanatory relations.}

\item{evidence}{vector of evidence for phenomena.}

\item{phenomena}{vector of phenomena should be the same length as evidence.}

\item{theory1}{vector of propositions in theory1.}

\item{theory2}{vector of propositions in theory2.}

\item{analytic}{whether the result should be calculated analytically or (for large networks) estimated using
Metropolis-Hastings algorithm enhanced with Coupling from the past.}

\item{analogy}{this argument is only for purposes of adding analogy in the future and should currently not be used.}
}
\value{
returns an IMEC object which contains the explanatory coherence of the propositions, the explanatory relations,
the evidence, and the phenomena
}
\description{
Computes IMEC based on previously specified explanatory relations.
}
\examples{
# simple example comparing two hypotheses one of them with more explanatory breadth##
T1 <- c("H1", "H2")
Phenomena <- c("E1", "E2")
Thresholds <- c(2,2)
explanations <- initializeNetwork(Phenomena, T1)
explanations <- explain("H1", "E1", explanations)
explanations <- explain("H1", "E2", explanations)
explanations <- explain("H2", "E2", explanations)
explanations <- contradict("H1", "H2", explanations)
coherence <- computeIMEC(explanations, Thresholds, Phenomena, T1)
summary(coherence)
plot(coherence)
}
