% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.getKM.R
\name{plot.getKM}
\alias{plot.getKM}
\title{Graph and compare the K-M curve from reconstructed IPD with the read-in coordinates}
\usage{
\method{plot}{getKM}(x, ...)
}
\arguments{
\item{x}{the object returned by other functions.}

\item{...}{ignored arguments}
}
\description{
Graph the survival curve based on the reconstructed IPD, and compare it with the input coordinates.
       The output includes three graphs: (1) The estimated K-M curve versus read-in; (2) The estimated numbers of patients
       at risk versus reported; and (3) The estimated survival probabilities minus read-in survival probabilities over time.
}
\examples{

# Radiationdata$radio is a dataset exported from ScanIt software ================
radio <- Radiationdata$radio

# Load time points when the patients number ========
# at risk reported (i.e. trisk in month) =========
trisk <- Radiationdata$trisk

# Load the numbers of patients at risk reported (i.e. nrisk) ========
# at the time points (trisk) =============
nrisk.radio <- Radiationdata$nrisk.radio

##### Use the trisk and nrisk as input ==========
pre_radio_1 <- preprocess(dat=Radiationdata$radio, trisk=trisk,nrisk=nrisk.radio,maxy=100)
est_radio_1 <- getIPD(prep=pre_radio_1,armID=0,tot.events=NULL)
# Output include reconstructed individual patients data
head(est_radio_1$IPD)
# Plot
plot(est_radio_1)

##### When trisk and nrisk were not available, then we must input ========
##### the initial number of patients                              ========
pre_radio_2 <- preprocess(dat=Radiationdata$radio, totalpts=213,maxy=100)
est_radio_2 <- getIPD(prep=pre_radio_2,armID=0,tot.events=NULL)
# Output include reconstructed individual patients data
head(est_radio_2$IPD)
# Plot
plot (est_radio_2)

}
\references{
Guyot P, Ades AE, Ouwens MJ, Welton NJ. Enhanced secondary analysis of survival data: reconstructing the data from published Kaplan-Meier survival curves. BMC Med Res Methodol.2012; 1:9.
}
