% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/school_preferences.R
\name{school_preferences}
\alias{school_preferences}
\title{Function for Selecting Institution by Preferences}
\usage{
school_preferences(
  financial_aid = 0,
  size = -Inf,
  region = NULL,
  diversity_students = 0,
  diversity_staff = 0,
  disabled = 0,
  affiliation = -Inf,
  relig_affil = NULL,
  calsys = NULL,
  openadmp = -Inf,
  vet_programs = NULL,
  alt_credits = NULL,
  yrscoll = -Inf,
  counsel_service = NULL,
  employ_service = NULL,
  daycare_service = NULL,
  alt_tuition = NULL,
  dist_educ = NULL,
  live_oncamp = -Inf,
  room_price = 0,
  board_price = 0,
  app_fee = 0
)
}
\arguments{
\item{financial_aid}{(numeric) Percent of undergraduate students awarded aid.}

\item{size}{(numeric) Amount of Students attending the institution. (-4 = Any Size; 1    = Under 1,000; 2 = 1,000 - 4,999; 3    = 5,000 - 9,999; 4 = 10,000 - 19,999; 5    = 20,000 and above; -1 = Not reported; -2    = Not applicable)}

\item{region}{(character) Region the institution resides.}

\item{diversity_students}{(numeric) Percent of non-white students. Returns inputted percent and higher.}

\item{diversity_staff}{(numeric) Percent of non-white staff. Returns inputted percent and higher.}

\item{disabled}{(numeric) Percent of disabled students. Returns inputted percent and higher.}

\item{affiliation}{(numeric) Institutional affiliation. (1    = Public, 2    = Private for-profit, 3    = Private not-for-profit (no religious affiliation), 4 = Private not-for-profit (religious affiliation))}

\item{relig_affil}{(numeric) Indicates religious affiliation (denomination) for private not-for-profit institutions that are religiously affiliated. (See \code{relig_aff} dataset for more information.)}

\item{calsys}{(numeric) Standard academic term (1    = Semester, 2    = Quarter, 3 = Trimester, 4    = Four-one-four plan, 5    = Other academic year, 6 = Differs by program, 7 = Continuous, -2    = Not applicable)}

\item{openadmp}{(numeric) OPEN ADMISSION - Admission policy whereby the school will accept any student who applies. (1 = Yes, 2 = No)}

\item{vet_programs}{(character) Programs offered to Veterans ("Yes" or blank)}

\item{alt_credits}{(character) Alternate credits taken by institution ("Yes" or blank)}

\item{yrscoll}{(numeric) Years of completed college-level work are required for entrance (1 = One, 2    = Two, 3 = Three, 4 = Four, 5 = Five, 6 = Six, 8 = Eight, -1 = Not reported, -2    = Not applicable)}

\item{counsel_service}{(character) Offers activities designed to assist students in making plans and decisions related to their education, career, or personal development. ("Yes" or blank)}

\item{employ_service}{(character) Offers activities intended to assist students in obtaining part-time employment as a means of defraying part of the cost of their education. ("Yes" or blank)}

\item{daycare_service}{(character) Offers A student service designed to provide appropriate care and protection of infants, preschool, and school-age children so their parents can participate in postsecondary education programs. ("Yes" or blank)}

\item{alt_tuition}{(character) Offers alternative tuition plans ("Yes" or blank)}

\item{dist_educ}{(character) Offers distance education opportunities ("Yes" or blank)}

\item{live_oncamp}{(numeric) First-time degree/certificate-seeking students required to live on campus or in institutionally-controlled housing ("Yes" or blank)}

\item{room_price}{(numeric) Price for room (0-9990)}

\item{board_price}{(numeric) Price for board (0-9760)}

\item{app_fee}{(numeric) Price for application fee (0-99)}
}
\value{
A data frame of the institution that fit inputted preferences. For arguments that represent percentages, the user can expect institutions that meet that percentage or higher; for arguments that represent amounts, the user can expect institutions that meet that amount or lower.
}
\description{
Lists the names of institutions that fit inputted preferences
}
\examples{
school_preferences(size = 2, alt_credits = "Yes", diversity_students = 30, diversity_staff = 20)
school_preferences(size = 3, daycare_service = "Yes", app_fee = 50, region = "Southeast")
}
