% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove.data.R
\name{remove.data}
\alias{remove.data}
\title{Remove an undesirable observation.}
\usage{
remove.data(datum, i)
}
\arguments{
\item{datum}{The data set. Should be an array.}

\item{i}{The index in the matrix of the data to be removed.}
}
\value{
Return the new data set without the observation that was removed.
}
\description{
This function removes an undesirable data that might be out of control in
you data set. It is used at Hotelling T2 control charts for phase I.
}
\examples{

mu <- c(5.682, 88.22)
Sigma <- symMatrix(c(3.770, -5.495, 13.53), 2)
datum <- data.1(20, 10, mu, Sigma)
# Removing the observatiob 13 from the data set "datum" and updating it:
datum <- remove.data(datum, 13)

}
\author{
Daniela R. Recchia, Emanuel P. Barbosa
}
