% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get_ARDS_Win_Probability.R
\name{Get_ARDS_Win_Probability}
\alias{Get_ARDS_Win_Probability}
\title{Provides analysis results related to the I-SPY ARDS composite ranking.}
\usage{
Get_ARDS_Win_Probability(
  TRT,
  Time_To_Death,
  Days_On_Ventilator,
  Days_On_Advanced_O2
)
}
\arguments{
\item{TRT}{Treatment vs control indicator Vector (1s and 0s).}

\item{Time_To_Death}{Vector containing time to death for participants from study entry.}

\item{Days_On_Ventilator}{Vector containing the number of days on ventilator for participants within the first 28 days of study enrollment. The I-SPY ARDS trial counts days on ventilator as the number of days from study entry until the day that ventilator is discontinued for good in the first 28 days.}

\item{Days_On_Advanced_O2}{Vector containing the number of days that each participant was on advanced respiratory support within the first 28 days of study enrollment.}
}
\value{
A list of 4 results based on the hierarchical composite ARDS ranking including: (1) The posterior probability and p-value used for graduation, (2) The Bayesian Wilcoxon/Mann-Whitney U test results along with posterior summaries on the Win Probability, (3) Frequentist summaries of the Win Probability, Win Ratio, and 2 sided Wilcoxon P-value, and (4) Component-wise interpretation of the composite win-ranking. This includes frequentist comparisons of the 28 day mortality rate, ventilator days in survivors, how many ties there were based on mortality and ventilation, and the advanced respiratory day distribution in tied patients.
}
\description{
Provides analysis results related to the I-SPY ARDS composite ranking.
}
\examples{
###load("Example_ARDS.rda")
library(DFBA)
Get_ARDS_Win_Probability(Example_Data$Treatment,Example_Data$Time_To_Death,
Example_Data$Days_On_Ventilator,Example_Data$Days_On_Advanced_O2)
}
