% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stReg.R
\name{residuals.stein}
\alias{residuals.stein}
\title{Extract Model Residuals}
\usage{
\method{residuals}{stein}(object, ...)
}
\arguments{
\item{object}{An object of class \code{stein}.}

\item{...}{Other arguments.}
}
\value{
A vector of residuals.
}
\description{
Residuals values based on model object \code{stein}.
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
p <- ncol(X)
# H beta = h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nr = 3, nc = p, byrow = TRUE)
h <- rep(0, nrow(H))
model <- stReg(X, y, H, h)
residuals(model)
}
\seealso{
\code{\link{residuals.unrestricted}},
\code{\link{residuals.restricted}},
\code{\link{residuals.preliminaryTest}},
\code{\link{residuals.improvedpreliminaryTest}},
\code{\link{residuals.positivestein}},.
}
