% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unrReg.R
\name{unrReg}
\alias{unrReg}
\title{The Unrestricted estimator}
\usage{
unrReg(X, y)
}
\arguments{
\item{X}{Matrix with input observations, of dimension \code{n} x \code{p}, where
each row is an observation vector;}

\item{y}{Vector with response observations of size \code{n}.}
}
\value{
An object of class \code{unrestricted} is a list containing at least the following components:
  \describe{
    \item{\code{coef}}{A named vector of coefficients.}
    \item{\code{residuals}}{The residuals, that is, the response values minus fitted values.}
    \item{\code{s2}}{The estimated variance.}
    \item{\code{fitted.values}}{The fitted values.}
  }
}
\description{
This function calculates the unrestricted estimator as
\deqn{\hat{\beta}^{U} = (X^{\top} X)^{-1} X^{\top} y}
where \eqn{^{\top}} denotes the transpose of a matrix. It is important to note that the
input matrices \eqn{X} and \eqn{y} should be standardized, for example, by
using \code{\link[base]{scale}}. Alternatively, the user can employ
\code{\link[stats]{lm}} to obtain this estimator, but it is crucial to
remember to set \code{intercept = FALSE}.
}
\details{
The corresponding unrestricted estimator of \eqn{\sigma^2} is
\deqn{s^2 = \frac{1}{n-p}(y-X\hat{\beta}^{U})^{\top}(y - X\hat{\beta}^{U}).}
}
\examples{
data(cement)
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
unrReg(X, y)

data(cement)
X <- as.matrix(cbind(1, cement[, 1:4]))
y <- cement$y
# Based on Kaciranlar et al. (1999)
H <- matrix(c(0, 1, -1, 1, 0), nrow = 1, ncol = 5, byrow = TRUE)
h <- rep(0, nrow(H))
unrReg(X, y)

H <- matrix(c(0, 1, -1, 1, 0, 0, 0, 1, -1, -1, 0, 1, -1, 0, -1), nrow = 3, ncol = 5, byrow = TRUE)
h <- rep(0, nrow(H))
unrReg(X, y)
}
\references{
Saleh, A. K. Md. Ehsanes. (2006). \emph{Theory of Preliminary Test and
 Stein‐Type Estimation With Applications}, Wiley.
}
