% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyses_data.R
\docType{data}
\name{analyses_data}
\alias{analyses_data}
\title{Analyses Data for imputing categorical covariates}
\format{
A data frame with 2000 rows and 10 variables
}
\usage{
data(analyses_data)
}
\description{
A dataset containing longitudinal data. The outcome of interest is the smoking status with three states (smoker, exsmoker, neversmoker),
which are represented via transitions. The difference from the initial data is the prob_matrix column.
}
\details{
\itemize{
  \item {patient_id}: {Unique identifier for each patient}
  \item {tran_Year}: {numeric, starting from 1 up to the number of transitions}
  \item {transition_year}: {text explanation of the transition}
  \item {state_from}: {the state at the beginning of a transition}
  \item {state_to}: {the state at the end of a transition}
  \item {prob_matrix}: {the probability matrix that was generated by the initial data}
  \item {cardio_state_from}: {cardiovascular disease at the beginning of the transition, binary, if 1 == Yes, else No}
  \item {cardio_state_to}: {cardiovascular disease at the end of the transition, binary, if 1 == Yes, else No}
  \item {flu_vaccination_state_from}: {flu vaccination at the end of the transition, binary, if 1 == Yes, else No}
  \item {flu_vaccination_state_to}: {flu vaccination disease at the end of the transition, binary, if 1 == Yes, else No}
}
}
\keyword{datasets}
