% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramb.R
\name{parmb}
\alias{parmb}
\title{Parametric Based Tests for Incomplete Paired Data}

\description{
The function performs testing the Hypothesis of equality of means for the incomplete pairs setting data. The function uses six test statistics that were proposed for testing the equality of the means of a bivariate normal distribution with unknown common variance and correlation coefficient when observations are missing on both variates. These function includes Lin and Stivers (1974, Ts),  Bhoj (1989, pp. 282, Z), Bhoj (1989, pp. 282, Zb),  Bhoj  (1989, pp. 283, T), Bhoj (1989, pp. 283, Zh) and Bhoj (1989, pp 284, Zls). For more details, information of the functions see Bhoj (1989).
}

\usage{
parmb(xp, yp, xu, yu, r, mu = NULL, method = "Zb",
      alternative = "two.sided", verbose = TRUE)
}

\arguments{
\item{xp, yp}{(non-empty) numeric vectors of data values of the the complete pairs}
\item{xu}{a numeric vector of data on x only}
\item{yu}{a numeric vector of data on y only}
\item{r}{a number indicating the correlation between the complete pairs}
\item{mu}{a number indicating the true value of the mean (or difference in means if you are performing a two sample test)}
\item{method}{a character string specifying the different type of methods, must be one of "Zb" (default), "Zb","T","Tls" ,"Zls","Zh"}
\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less"}
\item{verbose}{if TRUE, show the test statistic used, null and alternative hypotheses in addition to the p-value}

}

\value{A S4 object containing the following components:
\item{Title}{a character string describing the test statistic used}
\item{Nhypothesis}{a character string describing the null hypothesis}
\item{Ahypothesis}{a character string describing the alternative hypothesis}
\item{Pval}{the p-value for the test}
}

\references{
1 Bhoj, D. S. (1991). Testing equality of means in the presence of correlation and missing data. Biometrical journal, 33(1), 63-72.

2 Ekbohm, G. (1976). On comparing means in the paired case with incomplete data on both responses. Biometrika 63(2), 299-304.

3 Lin, P. E., & Stivers, L. E. (1974). On difference of means with incomplete data. Biometrika, 61(2), 325-334.
}

\examples{
n=20
n1=15
n2=10
r=0.8
xp=rnorm(n)
yp=r*xp+(1-r)*(rnorm(n))
xu=rnorm(n1)
yu=rnorm(n2)
mu=0
parmb(xp,yp,xu,yu,r,mu,method="Zb",alternative="two.sided")
}

