% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossdep_2series.R
\name{crossdep_2series}
\alias{crossdep_2series}
\title{Cross-dependences for testing independence between the innovations of 2 series of same length}
\usage{
crossdep_2series(x, y, lag, graph = TRUE)
}
\arguments{
\item{x}{Pseudo-observations (or residuals) of first series}

\item{y}{Pseudo-observations (or residuals) of second series}

\item{lag}{Maximum number of lags around 0}

\item{graph}{Set to TRUE for a correlogram for all possible lags.}
}
\value{
\item{stat}{Cross-dependences for all lags}

\item{H}{Sum of squares of cross-dependences}

\item{pvalue}{P-value of H}

\item{subsets}{c(-lag:lag)}

\item{n}{length of the time series}
}
\description{
This function computes the cross-dependence  between x(t) and y(t-l), for Spearman, van der Waerden and Savage dependence measures, for l=-lag,.., lag, and also the combination (Wald's type)  of these statistics.
}
\examples{
data(gas)
outr <-crossdep_2series(gas$xres,gas$yres,3)

}
\references{
Duchesne, Ghoudi & Remillard  (2012). On Testing for independence between the innovations of several time series. CJS, vol. 40, 447-479.

Nasri & Remillard  (2024). Tests of independence and randomness for arbitrary data using copula-based covariances. JMVA, vol. 201, 105273.
}
