% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependogram.R
\name{dependogram}
\alias{dependogram}
\title{Dependogram for Cramer-von Mises statistics}
\usage{
dependogram(object, stat, rot = 0)
}
\arguments{
\item{object}{List of the output (statistics, pvalues) from cvm_2series and cvmr_3series}

\item{stat}{Name (string) of statistics to be used}

\item{rot}{Rotation of labels  (default=0)}
}
\value{
\item{Output}{No values are returned; only the graph is printed}
}
\description{
This function, used in cvm_2series and cvm_3series draws the P-values of the Moebius Cramer-von Mises statistics.
}
\examples{
#Romano-Siegel's example #
data(romano_ex)
out = cvm_3series(romano_ex$x,romano_ex$y,romano_ex$z,5,2)
dependogram(out$out123,"{x,y,z}",rot=90)

}
\references{
Duchesne, Ghoudi & Remillard  (2012). On Testing for independence between the innovations of several time series. CJS, vol. 40, 447-479.
}
