% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inquilab.R
\name{plot_second_order_kinetics}
\alias{plot_second_order_kinetics}
\title{Plot for Second Order Kinetics}
\usage{
plot_second_order_kinetics(t, c, kinetic_model)
}
\arguments{
\item{t}{Numeric vector, time points.}

\item{c}{Numeric vector, concentrations corresponding to each time point.}

\item{kinetic_model}{Model object, result of lm function fitting 1/c ~ t.}
}
\value{
This function generates a plot of the actual vs. predicted concentrations based on the provided kinetic model and data points. The plot is rendered directly to the active plotting device.
}
\description{
This function plots the actual and transformed (1/c) concentrations based on second-order kinetics.
}
\examples{
t <- c(0, 5, 10, 15, 20, 25)
c <- c(100, 80, 60, 40, 20, 10)
model <- lm(1/c ~ t)
plot_second_order_kinetics(t, c, model)
}

