% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterVA5.summary.R
\name{summary.interVA5}
\alias{summary.interVA5}
\title{Summary of the results obtained from InterVA5 algorithm}
\usage{
\method{summary}{interVA5}(object, top = 5, id = NULL, InterVA.rule = TRUE, ...)
}
\arguments{
\item{object}{fitted object from \code{InterVA5()}}

\item{top}{number of top CSMF to show}

\item{id}{the ID of a specific death to show}

\item{InterVA.rule}{If it is set to "TRUE", only the top 3 causes reported by
InterVA5 is calculated into CSMF as in InterVA5. The rest of probabilities
goes into an extra category "Undetermined". Default set to "TRUE".}

\item{...}{not used}
}
\description{
This function prints the summary message of the fitted results.
}
\examples{
\dontrun{
data(RandomVA5)
# only fit first 20 observations for a quick illustration
RandomVA5 <- RandomVA5[1:20, ]

## to get easy-to-read version of causes of death make sure the column
## orders match interVA5 standard input this can be monitored by checking
## the warnings of column names

sample.output1 <- InterVA5(RandomVA5, HIV = "h", Malaria = "l", 
    write = FALSE, directory = tempdir(), filename = "VA5_result", 
    output = "extended", append = FALSE)

summary(sample.output1)
summary(sample.output1, top = 10)
summary(sample.output1, id = "sample3")
}
}
\references{
http://www.interva.net/
}
\keyword{InterVA}
