% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_interaction_r2_covs.R
\name{power_interaction_r2_covs}
\alias{power_interaction_r2_covs}
\title{Analytic interaction power analysis with covariates}
\usage{
power_interaction_r2_covs(
  cov.input,
  N,
  alpha = 0.05,
  detailed_results = FALSE,
  cl = NULL
)
}
\arguments{
\item{cov.input}{Output of 'power_interaction_r2_covs()'. Variable correlations and reliabilities are set by first modifying this list.}

\item{N}{Sample size. Must be a positive integer. Has no default value. Can be a single value or a vector of values.}

\item{alpha}{The alpha. At what p-value is the interaction deemed significant? Default is 0.05.}

\item{detailed_results}{Default is FALSE. Should detailed results be reported?}

\item{cl}{Number of clusters to use for running simulations in parallel. Default is NULL (i.e. not in parallel). Useful when running several thousand analyses at once.}
}
\value{
A data frame containing the analytic power for each unique setting combination.
}
\description{
Analytic power analysis of an interaction model with covariates. Additional covariate x main effect interaction terms are additionally added.
}
\examples{
ex1 = generate.interaction.cov.input(c.num=2)
ex1$correlations$r.y.x1x2 = c(0.1,0.2,0.3)
power_interaction_r2_covs(cov.input = ex1,N=100)
}
