% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-IntervalData.R
\docType{class}
\name{IntervalData-class}
\alias{IntervalData-class}
\title{S4 class representing a single interval}
\description{
Each nonempty compact real interval \eqn{K} can be alternatively
characterized in terms of either its lower and upper bounds (also
called infimum and supremum, respectively) through what is usually
known as its \emph{inf/sup}-characterization or either its mid-point
and spread (also named center and radius, respectively) by means of its
\emph{mid/spr}-characterization as follows,
\deqn{K = [\inf K,\sup K]=[\mathrm{mid}~K \mp \mathrm{spr}~K],}
where both \eqn{\inf K \leq \sup K} and \eqn{\mathrm{spr}~K \geq 0}
conditions are fulfilled. The existing equivalence relation between these
two characterizations is given by the following two equations:
\deqn{\mathrm{mid}~K = \frac{\sup K + \inf K}{2}
\qquad \mathrm{and} \qquad
\mathrm{spr}~K = \frac{\sup K - \inf K}{2}.}
}
\section{Slots}{

\describe{
\item{\code{mid}:}{A single real number saved as a unique \code{numeric}
value specifying the mid-point of the interval.}
\item{\code{spr}:}{A single real number saved as a unique \code{numeric}
value specifying the spread of the interval.}
}
}

\examples{
showClass("IntervalData")
showMethods(classes = "IntervalData")
}
\seealso{
Objects of \code{IntervalData} class should be created through
\code{\link{IntervalData}()} function. Besides \code{IntervalData} class,
the \pkg{IntervalQuestionStat} package also incorporates
\code{\link{IntervalList-class}} and \code{\link{IntervalMatrix-class}}
for dealing with interval-valued data in R environment.
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
