% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-extract.R
\docType{methods}
\name{extract}
\alias{extract}
\alias{[,IntervalList-method}
\alias{[[,IntervalList-method}
\alias{[,IntervalMatrix-method}
\alias{[<-,IntervalList-method}
\alias{[[<-,IntervalList-method}
\alias{[<-,IntervalMatrix-method}
\title{Extract and replace parts of an interval-valued object}
\usage{
\S4method{[}{IntervalList}(x, i)

\S4method{[[}{IntervalList}(x, i)

\S4method{[}{IntervalMatrix}(x, i, j)

\S4method{[}{IntervalList}(x, i) <- value

\S4method{[[}{IntervalList}(x, i) <- value

\S4method{[}{IntervalMatrix}(x, i, j) <- value
}
\arguments{
\item{x}{A list with several nonempty compact intervals or a matrix of
intervals of this family, that is, an \code{IntervalList} object or
an \code{IntervalMatrix} instance.}

\item{i}{The indices of the elements of the list or the rows of the elements
of the matrix wanted to be extracted saved as a \code{numeric},
\code{integer}, or \code{logical} object.}

\item{value}{A single nonempty compact interval or a list or matrix of
intervals saved of this family stored as an \code{IntervalData},
\code{IntervalList}, or \code{IntervalMatrix} object.}

\item{j}{The indices of the columns of the matrix's elements wanted to be
selected and extracted saved as a \code{numeric}, \code{integer}, or
\code{logical} object.}
}
\value{
It should be remarked that, on the one hand, the \code{[} command returns
the selected elements as a list of intervals, that is, an
\code{IntervalList} object, when it is used for \code{IntervalList}
instances. On the other hand, it returns \code{IntervalData},
\code{IntervalList}, or \code{IntervalMatrix} objects when it is used
with \code{IntervalMatrix} instances. The \code{[[} command allows to
extract a single interval, that is, an \code{IntervalData} object, from
a list of several intervals saved as an \code{IntervalList} object. Finally,
both \code{[<-} and \code{[[<-} commands allow to replace the selected
elements of the given interval-valued object by another object of the
required class and, thus, they do not return any value.
}
\description{
This command allows to extract and replace
parts of interval-valued lists or matrices.
}
\details{
Both \code{i} and \code{j} can also be negative integers, indicating the
elements lo leave out of the selection.
}
\examples{
## Extract parts of a list of intervals
list <- IntervalList(c(1, 3, 5), c(2, 4, 6))
list[1]        ## Extract the first interval
               ## Note that the output is an IntervalList object
list[[1]]      ## The first interval is extracted as an IntervalData object
list[c(1, 3)]  ## Extract the first and the third interval

## Extract parts of a matrix of intervals
m <- IntervalMatrix(matrix(c(1, 5, 2, 6, 6, 2, 7, 3, 3, 4, 4, 5), 2, 6))
m[1, 1]        ## Extract the interval from the first row and first column
m[1,]          ## Extract all the intervals from the first row
m[, 1]         ## Extract all the intervals from the first column
m[, c(1, 3)]   ## Extract the sub-matrix containing all the intervals
               ## from both first and third column of the original matrix
               
## Replace parts of a list of intervals
list[[1]]
list[[1]] <- IntervalData(0, 1)
list[[1]]

list[c(1, 3)]
list[c(1, 3)] <- IntervalList(c(0, 1), c(1, 2))
list[c(1, 3)]

## Replace parts of a matrix of intervals
m[1, 1]
m[1, 1] <- IntervalData(0, 1)
m[1, 1]

m[1, 1:2]
m[1, 1:2] <- IntervalList(c(0, 1), c(1, 2))
m[1, 1:2]

m[, c(1, 3)]
m[, c(1, 3)] <- IntervalMatrix(matrix(1:8, 2, 4))
m[, c(1, 3)]

}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
