% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-length.R
\docType{methods}
\name{length}
\alias{length}
\alias{length,IntervalList-method}
\title{Get the length of an \code{IntervalList} object}
\usage{
\S4method{length}{IntervalList}(x)
}
\arguments{
\item{x}{A list of nonempty compact real intervals
stored as an \code{IntervalList} object.}
}
\value{
This function returns a single numeric value indicating
the length of a list with several nonempty compact real
intervals. Therefore, it always returns an \code{integer}
object of whose length is one.
}
\description{
This function allows to get the length of an interval-valued list,
that is, the number of different nonempty compact real intervals
stored in an \code{IntervalList} object.
}
\examples{
## Some length() examples

list1 <- IntervalList(c(0, 2, 5), c(1, 6, 10))
length(list1)

dataframe <- data.frame(mids = c(0.5, 4, 7.5, 5),
                        sprs = c(0.5, 2, 2.5, 1))
list2 <- IntervalList(dataframe, type = 2)
length(list2)
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
