% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barrier.R
\name{calculate_barrier.Isingland}
\alias{calculate_barrier.Isingland}
\alias{calculate_barrier.2d_Isingland}
\alias{calculate_barrier.2d_Isingland_matrix}
\alias{print.barrier_2d_Isingland}
\alias{summary.barrier_2d_Isingland}
\alias{summary.barrier_2d_Isingland_matrix}
\title{Calculate energy barrier for Ising landscapes}
\usage{
\method{calculate_barrier}{`2d_Isingland`}(l, ...)

\method{calculate_barrier}{`2d_Isingland_matrix`}(l, ...)

\method{print}{barrier_2d_Isingland}(x, simplify = FALSE, ...)

\method{summary}{barrier_2d_Isingland}(object, ...)

\method{summary}{barrier_2d_Isingland_matrix}(object, ...)
}
\arguments{
\item{l}{An \code{Isingland} object constructed with \code{\link[=make_2d_Isingland]{make_2d_Isingland()}} or \code{\link[=make_2d_Isingland_matrix]{make_2d_Isingland_matrix()}}.}

\item{...}{Not in use.}

\item{x}{a result of the \emph{default} method of \code{summary()}.}

\item{simplify}{Print a simplified version of the output? Default is \code{FALSE}.}

\item{object}{an object for which a summary is desired.}
}
\value{
A \code{barrier_Isingland} object that contains the following components:
\itemize{
\item \code{shape} A character describing the shape of the landscape.
\item \code{local_min_start},\code{local_min_end},\code{saddle_point} The positions of the
two local minimums and the saddle point, described each by a list containing:
\itemize{
\item \code{U} The potential value.
\item \code{location}
\itemize{
\item \code{x_index} The row index in \code{get_dist(l)}.
\item \code{x_value} The number of active nodes.
}
}
\item \code{delta_U_start},\code{delta_U_end} The barrier heights for both sides.
}
}
\description{
Calculate energy barrier for Ising landscapes
}
\section{Functions}{
\itemize{
\item \code{summary(barrier_2d_Isingland)}: Return a vector of
barrier heights.

\item \code{summary(barrier_2d_Isingland_matrix)}: Return a tibble of
barrier heights and conditions.

}}
