% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_functions.R
\name{mass_bias}
\alias{mass_bias}
\title{mass_bias.}
\usage{
mass_bias(
  mi_amu = 0,
  si_amu = 0,
  method = c("Linear", "Russel", "Exponential"),
  f_value = 0
)
}
\arguments{
\item{mi_amu}{atomic mass of MI isotope.}

\item{si_amu}{atomic mass of SI isotope}

\item{method}{Method to calculate the mass bias.}

\item{f_value}{f_value to be used within the method calculation.}
}
\value{
A single numeric value K to be used for scaling.
}
\description{
\code{mass_bias} will calculate a correction factor K to
scale isotopic ratios and thereby account for machine variance.
}
\details{
Currently, 3 methods are available to calculate the mass bias,
Linear, Russel and Exponential. They all depend on the atomic mass
of the two ion traces and a f-value which can be provided as
parameters to the function.
}
\examples{
IsoCor::mass_bias(32, 34, "Linear", 0.1)
}
