% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrangling_issues.R
\name{new_issue}
\alias{new_issue}
\alias{new_issue.IssueTB}
\alias{new_issue.data.frame}
\alias{new_issue.list}
\alias{new_issue.IssuesTB}
\alias{new_issue.default}
\title{Create a new \code{IssueTB} object}
\usage{
new_issue(x = NULL, ...)

\method{new_issue}{IssueTB}(x, ...)

\method{new_issue}{data.frame}(x, ...)

\method{new_issue}{list}(x, ...)

\method{new_issue}{IssuesTB}(x, ...)

\method{new_issue}{default}(
  x,
  title = NA_character_,
  body = NA_character_,
  number = NA_integer_,
  state = NA_character_,
  created_at = Sys.Date(),
  closed_at = as.Date(NA_integer_),
  labels = NULL,
  milestone = NA_character_,
  repo = NA_character_,
  owner = NA_character_,
  url = NA_character_,
  html_url = NA_character_,
  comments = NULL,
  creator = NA_character_,
  assignee = NA_character_,
  state_reason = NA_character_,
  ...
)
}
\arguments{
\item{x}{a object representing an issue (\code{IssueTB} object, a \code{list}
or a \code{data.frame})}

\item{\dots}{Other information we would like to add to the issue.}

\item{title}{a string. The title of the issue.}

\item{body}{a string. The body (text) of the issue.}

\item{number}{a string. The number of the issue.}

\item{state}{a string that is either \code{"open"} (by default) if
the issue is still open or \code{"closed"} if the issue is now closed.}

\item{created_at}{a date (or timestamp). The creation date of the issue.}

\item{closed_at}{a date (or timestamp). The closing date of the issue.}

\item{labels}{a vector string (or missing). The labels of the issue.}

\item{milestone}{a string (or missing). The milestone of the issue.}

\item{repo}{A character string specifying the GitHub repository name (only
taken into account if \code{source} is set to \code{"online"}).
Defaults to the package option \code{IssueTrackeR.repo}.}

\item{owner}{A character string specifying the GitHub owner (only taken
into account if \code{source} is set to \code{"online"}).
Defaults to the package option \code{IssueTrackeR.owner}.}

\item{url}{a string. The URL of the API to the GitHub issue.}

\item{html_url}{a string. The URL to the GitHub issue.}

\item{comments}{vector of string (the comments of the issue)}

\item{creator}{a string. The GitHub username of the creator of the issue.}

\item{assignee}{a string. The GitHub username of the assignee of the issue.}

\item{state_reason}{a string. \code{"open"}, \code{"completed"},
\code{"reopened"}, \code{"not_planned"} or \code{"duplicated"}.}
}
\value{
a \code{IssueTB} object.
}
\description{
Create a new \code{IssueTB} object
}
\examples{
# Empty issue
issue1 <- new_issue()

# Custom issue
issue1 <- new_issue(
    title = "Nouvelle issue",
    body = "Un nouveau bug pour la fonction...",
    number = 47,
    created_at = Sys.Date()
)

issue2 <- new_issue(x = issue1)
}
