% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finding-objects.R
\name{with_comments}
\alias{with_comments}
\alias{with_comments.IssuesTB}
\title{Check for comments in GitHub Issues}
\usage{
with_comments(x, negate = FALSE)

\method{with_comments}{IssuesTB}(x, negate = FALSE)
}
\arguments{
\item{x}{An object of class \code{IssuesTB}.}

\item{negate}{boolean indicating if we are searching for issues WITHOUT
comments. Default is \code{FALSE}.}
}
\value{
An object \code{IssuesTB} with issues that satisfy the condition.
}
\description{
Function to filter issues with (or without) comments.
}
\examples{
all_issues <- get_issues(
    source = "local",
    dataset_dir = system.file("data_issues", package = "IssueTrackeR"),
    dataset_name = "open_issues.yaml"
)
with_comments(all_issues)
with_comments(all_issues, negate = TRUE)

}
