% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition.R
\name{transition}
\alias{transition}
\title{Create a \code{transition} object}
\usage{
transition(
  from,
  to,
  fun,
  transition_type,
  mortality_type = NULL,
  predictors = NULL,
  parameters = list()
)
}
\arguments{
\item{from}{The name of the life stage a tick is transitioning from.}

\item{to}{The name of the life stage a tick is transitioning to, or NULL if
the transition is representing mortality.}

\item{fun}{The transition function to evaluate.
The inputs of the function are predictors and parameters. The output is
the daily probability of completing the transition, for \code{"probability"}
transitions, or the daily rate the transition takes place, for \code{"duration"}
transitions.}

\item{transition_type}{One of:
\code{"probability"}: the evaluated transition is interpreted as the daily
fraction of ticks that complete the transition. Ticks remain in the
original life stage if they do not complete a transition or undergo
mortality.
\code{"duration"}: the transition is complete on the first day that the
cumulative sum of the evaluated transition is greater than or equal to 1.
No ticks remain in the original life stage at the end of a transition -
they either complete the transition or die.}

\item{mortality_type}{One of:
\code{NULL}: the default, indicating that the transition is not mortality.
\code{"per_day"}: indicates that the evaluated transition is the fraction of
ticks that dies each day.
\code{"throughout_transition"}: only valid for \code{"duration"} type transitions,
where it indicates that the evaluated transition is the fraction of
ticks that die throughout the entire transition.}

\item{predictors}{Optional, a named list of \code{\link{predictor_spec}} objects
that specify how any predictor data should be used in evaluating \code{fun}. The names are
matched with the formal args to  \code{fun} to determine which input in \code{fun}
each predictor will be passed to.}

\item{parameters}{Optional, a \code{\link{parameters}} object, or a named
list of numeric vectors.}
}
\value{
a \code{transition} object
}
\description{
A \code{transition} object represents a single transition between two tick life
stages, or the mortality rate from a life stage.
}
